const locales = {
    en: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "Welcome",
        loginPlease: "Please enter your API key to login",
        loginInfo: "Enter your API key to login. You can find your API key in your Settings page in your dashboard.",
        login: "Login",
        shortenTab: "Shorten",
        settingsTab: "Settings",
        linksTab: "My Links",
        longUrlLabel: "Long URL",
        brandedDomainLabel: "Branded Domain (optional)",
        customAliasLabel: "Custom Alias (optional)",
        shortenButton: "Shorten",
        backToShortener: "Back",
        shortLinkLabel: "Short Link",
        copyButton: "Copy",
        copied: "Copied!",
        apiKeyLabel: "API Key",
        saveApiKeyButton: "Save API Key",
        invalidApi: "Please enter a valid API Key.",
        apiNotSet: "API Key not set. Please set it to get started.",
        invalidURL: "Please enter a valid URL.",
        apiSet: "API Key saved successfully.",
        missingInfo: "Missing required information.",
        unexpectedError: "Unexpected error occurred.",
        defaultDomain: "Default Domain",
        viewMore: "View More",
        poweredBy: "Powered by",
        logoutConfirm: "Are you sure you want to logout?",
        logout: "Logout",
        cancel: "Cancel"
    },
    fr: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "Bienvenue",
        loginPlease: "Veuillez entrer votre clé API pour vous connecter",
        loginInfo: "Entrez votre clé API pour vous connecter. Vous pouvez trouver votre clé API dans la page Paramètres de votre tableau de bord.",
        login: "Connexion",
        shortenTab: "Raccourcir",
        settingsTab: "Paramètres",
        linksTab: "Mes Liens",
        longUrlLabel: "URL longue",
        brandedDomainLabel: "Domaine personnalisé (facultatif)",
        customAliasLabel: "Alias personnalisé (facultatif)",
        shortenButton: "Raccourcir",
        backToShortener: "Retour",
        shortLinkLabel: "Lien court",
        copyButton: "Copier",
        copied: "Copié !",
        apiKeyLabel: "Clé API",
        saveApiKeyButton: "Enregistrer la clé API",
        invalidApi: "Veuillez entrer une clé API valide.",
        apiNotSet: "Clé API non définie. Veuillez la définir pour commencer.",
        invalidURL: "Veuillez entrer une URL valide.",
        apiSet: "Clé API enregistrée avec succès.",
        missingInfo: "Informations requises manquantes.",
        unexpectedError: "Une erreur inattendue est survenue.",
        defaultDomain: "Domaine par défaut",
        viewMore: "Voir plus",
        poweredBy: "Propulsé par",
        logoutConfirm: "Êtes-vous sûr de vouloir vous déconnecter ?",
        logout: "Déconnexion",
        cancel: "Annuler"
    },
    it: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "Benvenuto",
        loginPlease: "Inserisci la tua chiave API per accedere",
        loginInfo: "Inserisci la tua chiave API per accedere. Puoi trovare la tua chiave API nella pagina delle Impostazioni nel tuo cruscotto.",
        login: "Accesso",
        shortenTab: "Accorcia",
        settingsTab: "Impostazioni",
        linksTab: "I Miei Link",
        longUrlLabel: "URL Lungo",
        brandedDomainLabel: "Dominio personalizzato (opzionale)",
        customAliasLabel: "Alias personalizzato (opzionale)",
        shortenButton: "Accorcia",
        backToShortener: "Indietro",
        shortLinkLabel: "Link corto",
        copyButton: "Copia",
        copied: "Copiato!",
        apiKeyLabel: "Chiave API",
        saveApiKeyButton: "Salva Chiave API",
        invalidApi: "Inserisci una chiave API valida.",
        apiNotSet: "Chiave API non impostata. Impostala per iniziare.",
        invalidURL: "Inserisci un URL valido.",
        apiSet: "Chiave API salvata con successo.",
        missingInfo: "Informazioni richieste mancanti.",
        unexpectedError: "Si è verificato un errore imprevisto.",
        defaultDomain: "Dominio predefinito",
        viewMore: "Vedi di più",
        poweredBy: "Offerto da",
        logoutConfirm: "Sei sicuro di voler uscire?",
        logout: "Esci",
        cancel: "Annulla"
    },
    de: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "Willkommen",
        loginPlease: "Bitte geben Sie Ihren API-Schlüssel ein, um sich anzumelden",
        loginInfo: "Geben Sie Ihren API-Schlüssel ein, um sich anzumelden. Sie finden Ihren API-Schlüssel auf der Seite Einstellungen in Ihrem Dashboard.",
        login: "Anmelden",
        shortenTab: "Kürzen",
        settingsTab: "Einstellungen",
        linksTab: "Meine Links",
        longUrlLabel: "Lange URL",
        brandedDomainLabel: "Gebrandete Domain (optional)",
        customAliasLabel: "Benutzerdefinierter Alias (optional)",
        shortenButton: "Kürzen",
        backToShortener: "Zurück",
        shortLinkLabel: "Kurzer Link",
        copyButton: "Kopieren",
        copied: "Kopiert!",
        apiKeyLabel: "API-Schlüssel",
        saveApiKeyButton: "API-Schlüssel speichern",
        invalidApi: "Bitte geben Sie einen gültigen API-Schlüssel ein.",
        apiNotSet: "API-Schlüssel nicht gesetzt. Bitte setzen Sie ihn, um zu beginnen.",
        invalidURL: "Bitte geben Sie eine gültige URL ein.",
        apiSet: "API-Schlüssel erfolgreich gespeichert.",
        missingInfo: "Fehlende erforderliche Informationen.",
        unexpectedError: "Ein unerwarteter Fehler ist aufgetreten.",
        defaultDomain: "Standard-Domain",
        viewMore: "Mehr anzeigen",
        poweredBy: "Bereitgestellt von",
        logoutConfirm: "Sind Sie sicher, dass Sie sich abmelden möchten?",
        logout: "Abmelden",
        cancel: "Abbrechen"
    },
    es: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "Bienvenido",
        loginPlease: "Por favor, introduzca su clave API para iniciar sesión",
        loginInfo: "Introduzca su clave API para iniciar sesión. Puede encontrar su clave API en la página de Configuración de su panel de control.",
        login: "Iniciar sesión",
        shortenTab: "Acortar",
        settingsTab: "Configuraciones",
        linksTab: "Mis Enlaces",
        longUrlLabel: "URL larga",
        brandedDomainLabel: "Dominio personalizado (opcional)",
        customAliasLabel: "Alias personalizado (opcional)",
        shortenButton: "Acortar",
        backToShortener: "Volver",
        shortLinkLabel: "Enlace corto",
        copyButton: "Copiar",
        copied: "¡Copiado!",
        apiKeyLabel: "Clave API",
        saveApiKeyButton: "Guardar clave API",
        invalidApi: "Por favor, introduzca una clave API válida.",
        apiNotSet: "Clave API no establecida. Por favor, configúrela para comenzar.",
        invalidURL: "Por favor, introduzca una URL válida.",
        apiSet: "Clave API guardada con éxito.",
        missingInfo: "Falta información requerida.",
        unexpectedError: "Ocurrió un error inesperado.",
        defaultDomain: "Dominio predeterminado",
        viewMore: "Ver más",
        poweredBy: "Desarrollado por",
        logoutConfirm: "¿Está seguro de que desea cerrar sesión?",
        logout: "Cerrar sesión",
        cancel: "Cancelar"
    },
	zh: {
        extensionTitle: "Linqii - URL Shorten",
        welcome: "欢迎",
        loginPlease: "请输入您的API密钥以登录",
        loginInfo: "请输入您的API密钥以登录。您可以在控制面板的设置页面中找到您的API密钥。",
        login: "登录",
        shortenTab: "缩短",
        settingsTab: "设置",
        linksTab: "我的链接",
        longUrlLabel: "长网址",
        brandedDomainLabel: "品牌域名（可选）",
        customAliasLabel: "自定义别名（可选）",
        shortenButton: "缩短",
        backToShortener: "返回",
        shortLinkLabel: "短链接",
        copyButton: "复制",
        copied: "已复制！",
        apiKeyLabel: "API密钥",
        saveApiKeyButton: "保存API密钥",
        invalidApi: "请输入有效的API密钥。",
        apiNotSet: "API密钥未设置。请设置以开始使用。",
        invalidURL: "请输入有效的URL。",
        apiSet: "API密钥保存成功。",
        missingInfo: "缺少必要信息。",
        unexpectedError: "发生意外错误。",
        defaultDomain: "默认域名",
        viewMore: "查看更多",
        poweredBy: "技术支持",
        logoutConfirm: "您确定要注销吗？",
        logout: "注销",
        cancel: "取消"
    }
};
